/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.superplan.evaluation;

import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.superplan.evaluation.ObjectiveFunction;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuperplanEvaluator {
    private static final Logger log = LoggerFactory.getLogger("cz.insophy.inplan.experimental.MokosExp");
    private List<GeneralizedOrderRequest> gors;

    public SuperplanEvaluator(Superplan superplan) {
        this.gors = new ArrayList<GeneralizedOrderRequest>(superplan.getGors());
        Iterator<GeneralizedOrderRequest> iterator = this.gors.iterator();
        while (iterator.hasNext()) {
            GeneralizedOrderRequest gor = iterator.next();
            if (gor.getEndDate() != -9223372036854775708L) continue;
            log.warn("Gor {} has not been planned. It won't be included in the Evaluator computations.", (Object)gor.getId());
            iterator.remove();
        }
    }

    public long computeMakespan() {
        long maxCompletion = 0L;
        for (GeneralizedOrderRequest gor : this.gors) {
            if (gor.getEndDate() <= maxCompletion) continue;
            maxCompletion = gor.getEndDate();
        }
        return maxCompletion;
    }

    public long computeTotalTardiness() {
        long totalTardiness = 0L;
        for (GeneralizedOrderRequest gor : this.gors) {
            totalTardiness += Math.max(gor.getEndDate() - gor.getDueDate(), 0L);
        }
        return totalTardiness;
    }

    public long computeFlowtime() {
        long flowtime = 0L;
        for (GeneralizedOrderRequest gor : this.gors) {
            flowtime += gor.getEndDate() - gor.getReleaseDate();
        }
        return flowtime;
    }

    public void evaluateWithObjectiveFunctions(EnumSet<ObjectiveFunction> objectiveFunctions) {
        log.info("Evaluating superplan...");
        for (ObjectiveFunction f : objectiveFunctions) {
            long result = 0L;
            switch (f) {
                case TOTAL_TARDINESS: {
                    result = this.computeTotalTardiness();
                    break;
                }
                case MAKESPAN: {
                    result = this.computeMakespan();
                    break;
                }
                case FLOWTIME: {
                    result = this.computeFlowtime();
                }
            }
            log.info("Value of " + f.toString() + ": " + Long.toString(result));
        }
    }
}

